/*
 * Decompiled with CFR 0.152.
 */
package net.hicham.zerolagoverlay;

import java.util.Objects;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.hicham.zerolagoverlay.ConfigManager;
import net.hicham.zerolagoverlay.ModConfig;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_640;

public class ZeroLagOverlayMod
implements ClientModInitializer {
    public static ModConfig config;
    private static final class_124 TEXT_COLOR;
    private static final int BACKGROUND_COLOR = Integer.MIN_VALUE;
    private static final int PADDING = 5;
    private static final int EXCELLENT_FPS = 60;
    private static final int GOOD_FPS = 30;
    private static final int EXCELLENT_PING = 100;
    private static final int GOOD_PING = 200;
    private static class_304 toggleOverlayKey;
    private static class_304 toggleFpsKey;
    private static class_304 togglePingKey;
    private static class_304 toggleMemoryKey;

    public void onInitializeClient() {
        ConfigManager.initialize();
        config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        this.registerKeybinds();
        ClientTickEvents.END_CLIENT_TICK.register(client -> this.handleKeybinds(client));
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            if (ZeroLagOverlayMod.config.enabled) {
                this.renderOverlay(drawContext);
            }
        });
    }

    private void registerKeybinds() {
        toggleOverlayKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.zerolagoverlay.toggle", class_3675.class_307.field_1668, 79, "category.zerolagoverlay"));
        toggleFpsKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.zerolagoverlay.toggle_fps", class_3675.class_307.field_1668, -1, "category.zerolagoverlay"));
        togglePingKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.zerolagoverlay.toggle_ping", class_3675.class_307.field_1668, -1, "category.zerolagoverlay"));
        toggleMemoryKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.zerolagoverlay.toggle_memory", class_3675.class_307.field_1668, -1, "category.zerolagoverlay"));
    }

    private void handleKeybinds(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        if (toggleOverlayKey.method_1436()) {
            ZeroLagOverlayMod.config.enabled = !ZeroLagOverlayMod.config.enabled;
            AutoConfig.getConfigHolder(ModConfig.class).save();
            this.sendFeedback(client, "Overlay", ZeroLagOverlayMod.config.enabled);
        }
        if (toggleFpsKey.method_1436()) {
            ZeroLagOverlayMod.config.showFps = !ZeroLagOverlayMod.config.showFps;
            AutoConfig.getConfigHolder(ModConfig.class).save();
            this.sendFeedback(client, "FPS Counter", ZeroLagOverlayMod.config.showFps);
        }
        if (togglePingKey.method_1436()) {
            ZeroLagOverlayMod.config.showPing = !ZeroLagOverlayMod.config.showPing;
            AutoConfig.getConfigHolder(ModConfig.class).save();
            this.sendFeedback(client, "Ping Display", ZeroLagOverlayMod.config.showPing);
        }
        if (toggleMemoryKey.method_1436()) {
            ZeroLagOverlayMod.config.showMemory = !ZeroLagOverlayMod.config.showMemory;
            AutoConfig.getConfigHolder(ModConfig.class).save();
            this.sendFeedback(client, "Memory Display", ZeroLagOverlayMod.config.showMemory);
        }
    }

    private void sendFeedback(class_310 client, String feature, boolean enabled) {
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)(feature + " " + (enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"))), false);
        }
    }

    private void renderOverlay(class_332 context) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        int[] position = this.calculatePosition(client);
        int posX = position[0];
        int posY = position[1];
        Objects.requireNonNull(client.field_1772);
        int lineHeight = 9 + 2;
        int yOffset = 0;
        int maxWidth = this.calculateMaxWidth(client);
        if (ZeroLagOverlayMod.config.showBackground && this.shouldShowBackground()) {
            this.drawBackground(context, posX, posY, maxWidth, lineHeight);
        }
        if (ZeroLagOverlayMod.config.showFps) {
            this.renderFps(context, client, posX, posY + yOffset);
            yOffset += lineHeight;
        }
        if (ZeroLagOverlayMod.config.showPing && client.method_1562() != null) {
            this.renderPing(context, client, posX, posY + yOffset);
            yOffset += lineHeight;
        }
        if (ZeroLagOverlayMod.config.showMemory) {
            this.renderMemory(context, posX, posY + yOffset);
        }
    }

    private int calculateMaxWidth(class_310 client) {
        int maxWidth = 0;
        if (ZeroLagOverlayMod.config.showFps) {
            maxWidth = Math.max(maxWidth, client.field_1772.method_1727("FPS: 999"));
        }
        if (ZeroLagOverlayMod.config.showPing) {
            maxWidth = Math.max(maxWidth, client.field_1772.method_1727("Ping: 999ms"));
        }
        if (ZeroLagOverlayMod.config.showMemory) {
            maxWidth = Math.max(maxWidth, client.field_1772.method_1727("Memory: 99.9/99.9GB"));
        }
        return maxWidth;
    }

    private boolean shouldShowBackground() {
        return ZeroLagOverlayMod.config.showFps || ZeroLagOverlayMod.config.showPing || ZeroLagOverlayMod.config.showMemory;
    }

    private void drawBackground(class_332 context, int posX, int posY, int maxWidth, int lineHeight) {
        int lineCount = 0;
        if (ZeroLagOverlayMod.config.showFps) {
            ++lineCount;
        }
        if (ZeroLagOverlayMod.config.showPing) {
            ++lineCount;
        }
        if (ZeroLagOverlayMod.config.showMemory) {
            ++lineCount;
        }
        context.method_25294(posX - 2, posY - 2, posX + maxWidth + 2, posY + lineCount * lineHeight, Integer.MIN_VALUE);
    }

    private void renderFps(class_332 context, class_310 client, int x, int y) {
        int fps = client.method_47599();
        class_124 fpsColor = this.getColorForFps(fps);
        this.renderColoredMetric(context, "FPS: ", String.valueOf(fps), "", fpsColor, x, y);
    }

    private void renderPing(class_332 context, class_310 client, int x, int y) {
        class_640 entry = client.method_1562().method_2871(client.field_1724.method_5667());
        int ping = entry != null ? entry.method_2959() : 0;
        class_124 pingColor = this.getColorForPing(ping);
        this.renderColoredMetric(context, "Ping: ", String.valueOf(ping), "ms", pingColor, x, y);
    }

    private void renderMemory(class_332 context, int x, int y) {
        Runtime rt = Runtime.getRuntime();
        long used = rt.totalMemory() - rt.freeMemory();
        long max = rt.maxMemory();
        String memoryText = String.format("%.1f/%.1fGB", Float.valueOf(this.bytesToGb(used)), Float.valueOf(this.bytesToGb(max)));
        this.renderText(context, "Memory: " + memoryText, x, y);
    }

    private void renderColoredMetric(class_332 context, String prefix, String value, String suffix, class_124 valueColor, int x, int y) {
        class_310 client = class_310.method_1551();
        context.method_27535(client.field_1772, (class_2561)class_2561.method_43470((String)prefix).method_27692(TEXT_COLOR), x, y, 0xFFFFFF);
        int prefixWidth = client.field_1772.method_1727(prefix);
        context.method_27535(client.field_1772, (class_2561)class_2561.method_43470((String)value).method_27692(valueColor), x + prefixWidth, y, 0xFFFFFF);
        if (!suffix.isEmpty()) {
            int valueWidth = client.field_1772.method_1727(value);
            class_124 suffixColor = suffix.equals("ms") ? valueColor : TEXT_COLOR;
            context.method_27535(client.field_1772, (class_2561)class_2561.method_43470((String)suffix).method_27692(suffixColor), x + prefixWidth + valueWidth, y, 0xFFFFFF);
        }
    }

    private class_124 getColorForFps(int fps) {
        if (fps >= 60) {
            return class_124.field_1060;
        }
        if (fps >= 30) {
            return class_124.field_1054;
        }
        return class_124.field_1061;
    }

    private class_124 getColorForPing(int ping) {
        if (ping <= 100) {
            return class_124.field_1060;
        }
        if (ping <= 200) {
            return class_124.field_1054;
        }
        return class_124.field_1061;
    }

    private int[] calculatePosition(class_310 client) {
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int posX = 5;
        int posY = 5;
        switch (ZeroLagOverlayMod.config.overlayPosition) {
            case TOP_RIGHT: {
                posX = screenWidth - 120 - 5;
                break;
            }
            case BOTTOM_LEFT: {
                posY = screenHeight - 70 - 5;
                break;
            }
            case BOTTOM_RIGHT: {
                posX = screenWidth - 120 - 5;
                posY = screenHeight - 70 - 5;
            }
        }
        return new int[]{posX, posY};
    }

    private void renderText(class_332 context, String text, int x, int y) {
        context.method_27535(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)text).method_27692(TEXT_COLOR), x, y, 0xFFFFFF);
    }

    private float bytesToGb(long bytes) {
        return (float)bytes / 1.0737418E9f;
    }

    static {
        TEXT_COLOR = class_124.field_1080;
    }
}

